#include <Adafruit_NeoPixel.h>
#include <SPI.h>
#include <bitBangedSPI.h>
#include <MAX7219_Dot_Matrix.h>
#include "ESPRotary.h";
#include "Button2.h"  //  https://github.com/LennartHennigs/Button2

#define ROTARY_PIN1 2
#define ROTARY_PIN2 3
#define BUTTON_PIN 4
#define PINWS 6
int matriz = 16;  //Tamaño en pixeles de la matrix 16x16
int margen = 1;   //pixeles entre los numeros y el area (separación).
//int max=8;
int fila;
int multiplo;
int pos;
int ini;
int pixeles = 256;
int intenso = 5;
int prime;
int segun;
char message[2] = "Hol";
boolean boton = 0;
int contador;
int solucion;

int led_intenso = 100;  //100 es soportado -->maximo posible 255.
int buzz = 5;
int fasel = 2;  //fases de 1 a 5
int aciertos = 0;

int asignacion[16][16] = { { 0, 31, 32, 63, 64, 95, 96, 127, 128, 159, 160, 191, 192, 223, 224, 255 },
                           { 1, 30, 33, 62, 65, 94, 97, 126, 129, 158, 161, 190, 193, 222, 225, 254 },
                           { 2, 29, 34, 61, 66, 93, 98, 125, 130, 157, 162, 189, 194, 221, 226, 253 },
                           { 3, 28, 35, 60, 67, 92, 99, 124, 131, 156, 163, 188, 195, 220, 227, 252 },
                           { 4, 27, 36, 59, 68, 91, 100, 123, 132, 155, 164, 187, 196, 219, 228, 251 },
                           { 5, 26, 37, 58, 69, 90, 101, 122, 133, 154, 165, 186, 197, 218, 229, 250 },
                           { 6, 25, 38, 57, 70, 89, 102, 121, 134, 153, 166, 185, 198, 217, 230, 249 },
                           { 7, 24, 39, 56, 71, 88, 103, 120, 135, 152, 167, 184, 199, 216, 231, 248 },
                           { 8, 23, 40, 55, 72, 87, 104, 119, 136, 151, 168, 183, 200, 215, 232, 247 },
                           { 9, 22, 41, 54, 73, 86, 105, 118, 137, 150, 169, 182, 201, 214, 233, 246 },
                           { 10, 21, 42, 53, 74, 85, 106, 117, 138, 149, 170, 181, 202, 213, 234, 245 },
                           { 11, 20, 43, 52, 75, 84, 107, 116, 139, 148, 171, 180, 203, 212, 235, 244 },
                           { 12, 19, 44, 51, 76, 83, 108, 115, 140, 147, 172, 179, 204, 211, 236, 243 },
                           { 13, 18, 45, 50, 77, 82, 109, 114, 141, 146, 173, 178, 205, 210, 237, 242 },
                           { 14, 17, 46, 49, 78, 81, 110, 113, 142, 145, 174, 177, 206, 209, 238, 241 },
                           { 15, 16, 47, 48, 79, 80, 111, 112, 143, 144, 175, 176, 207, 208, 239, 240 } };

Adafruit_NeoPixel pixels(pixeles, PINWS, NEO_GRB + NEO_KHZ800);

MAX7219_Dot_Matrix myDisplay(3, 10);                   // Primer numero es la cantidad de módulos (3 una pantalla, 6 dos pantallas); Segundo número es el PIN.
ESPRotary r = ESPRotary(ROTARY_PIN1, ROTARY_PIN2, 4);  //el 4 es por la peculiaridad de mi encoder, que cuenta 4 pasadas en cada salto.
Button2 b;

void setup() {
  Serial.begin(9600);
  Serial.println("Saludos");
  Serial.print("El Area Máximna es: ");
  Serial.print(matriz - margen - 1);
  Serial.print("x");
  Serial.print(matriz - margen - 1);
  Serial.print("=");
  Serial.println((matriz - margen - 1) * (matriz - margen - 1));
  pinMode(buzz, OUTPUT);
  randomSeed(analogRead(A0));  // Generamos una semilla aleatoria usando ruido del pin A0
  int caca = random(3000);     //He puesto esto aquí para evitar que salga siempre 1 en el primer número random. (Así he hecho trampa)
  pixels.begin();
  pixels.setBrightness(led_intenso);
  myDisplay.begin();
  myDisplay.setIntensity(intenso);
  if (fasel == 1) {                  //Numeros menores de 100
    myDisplay.sendSmooth("f:1", 0);  //-25 para escribir en la LCD 2 -- usar 0 para escribir en la LCD1 (Es el desplazamiento a la derecha).
  }
  if (fasel == 2) {  //normal con 14x14
    myDisplay.sendSmooth("f:2", 0);
  }
  if (fasel == 3) {  //No muestra el resultado al inicio
    myDisplay.sendSmooth("f:3", 0);
  }
  if (fasel == 4) {  //Sin puntos azules ni resultado al inicio, solos puntos blancos
    myDisplay.sendSmooth("f:4", 0);
  }
  if (fasel == 5) {  //Ni siquiera puntos blancos, solo el numero en la pantalla
    myDisplay.sendSmooth("f:5", 0);
  }
  delay(350);
  myDisplay.sendSmooth("", 0);
  delay(100);

  r.setLeftRotationHandler(showDirection);
  r.setRightRotationHandler(showDirection);

  b.begin(BUTTON_PIN);
  b.setTapHandler(click);
}

void loop() {

  Serial.print("Fase:");
  Serial.println(fasel);

  pixels.clear();
  genera_multuplicacion();
  propone();

  if (fasel <= 2) {  //Muestra solución en fases menores que 1 en LCD
    myDisplay.sendSmooth(message, 0);
  } else {
    myDisplay.sendSmooth("", 0);
  }
  pixels.show();
  boton = 0;


  while (boton != 1) {
    r.loop();
    b.loop();
  }
}

void click(Button2& btn) {
  if (contador == solucion) {
    aciertos++;
    tone(buzz, 800, 100);
    delay(100);
    tone(buzz, 1500, 100);
  } else {
    aciertos--;
    tone(buzz, 1500, 100);
    delay(100);
    tone(buzz, 800, 100);
  }
  if (aciertos <= 0) {
    aciertos = 0;
  }
  Serial.print("Aciertos:");
  Serial.println(aciertos);

  boton = 1;
  contador = 0;
  // myDisplay.sendSmooth("", 0);
}

void showDirection(ESPRotary& r) {
  if (r.directionToString(r.getDirection()) == "right") {  //Giro a la derecha
    multiplo = segun * (contador / segun);
    contador++;
    fila = (contador - 1) / segun;
    if (contador >= segun * 14) {
      contador = (segun * 14);
    }
    if (fasel <= 4) {
      pixels.setPixelColor(asignacion[fila + 2][(contador + 1) - multiplo], pixels.Color(255, 255, 255));  //blanco
    }
  }
  if (r.directionToString(r.getDirection()) == "left") {  //Giro a la izquierda
    contador--;
    if (contador <= 0) {
      contador = 0;
    }
    fila = contador / segun;
    multiplo = segun * (contador / segun);
    if (contador >= solucion) {
      pixels.setPixelColor(asignacion[fila + 2][(contador + 2) - multiplo], pixels.Color(0, 0, 0));  //negro
    } else {
      if (fasel <= 3) {
        pixels.setPixelColor(asignacion[fila + 2][(contador + 2) - multiplo], pixels.Color(0, 0, 255));  //repinta de azul
      } else {
        pixels.setPixelColor(asignacion[fila + 2][(contador + 2) - multiplo], pixels.Color(0, 0, 0));  //negro
      }
    }
  }

  if (contador % segun == 0 && contador != 0) {  //Al pasar por un mútiplo
    for (int j = 0; j < segun; j++) {            //amarillo
      pixels.setPixelColor(asignacion[(contador / segun) + 1][j + 2], pixels.Color(255, 255, 0));
    }
    pixels.show();

    itoa(contador, message, 10);
    intenso = 30;
    myDisplay.setIntensity(intenso);
    myDisplay.sendSmooth(message, 0);
    delay(20);
    for (int j = 0; j < segun; j++) {  //rosita
      pixels.setPixelColor(asignacion[(contador / segun) + 1][j + 2], pixels.Color(150, 150, 0));
    }
    pixels.show();
    intenso = 0;
    myDisplay.setIntensity(intenso);
    tone(buzz, 1500, 50);
    delay(50);
    for (int j = 0; j < segun; j++) {  //rosa
      pixels.setPixelColor(asignacion[(contador / segun) + 1][j + 2], pixels.Color(255, 0, 255));
    }
    pixels.show();
    delay(20);
    intenso = 0;
    myDisplay.setIntensity(intenso);
    delay(20);
    intenso = 30;
    myDisplay.setIntensity(intenso);
    delay(80);
  } else {
    pixels.show();
    itoa(contador, message, 10);
    myDisplay.setIntensity(2);
    tone(buzz, 1500, 2);
    delay(2);
    myDisplay.sendSmooth(message, 0);
  }
}

void genera_multuplicacion() {
  if (fasel <= 1) {  //Números menores de 10x10
    prime = random(1, 12 - margen);
    segun = random(1, 12 - margen);
  } else {  // Numeros hasta 14x14
    prime = random(1, matriz - margen);
    segun = random(1, matriz - margen);
  }
  //prime = 5;
  //segun = 1;

  // Serial.print(prime);
  // Serial.print("X");
  // Serial.print(segun);
  // Serial.print("=");
  solucion = prime * segun;
  // Serial.println(solucion);
  itoa(solucion, message, 10);
}

void propone() {
  pixels.setPixelColor(prime + margen, pixels.Color(0, 255, 0));  //nº Vertical
  pixels.setPixelColor(asignacion[prime + margen][1], pixels.Color(0, 255, 0));
  pixels.setPixelColor(asignacion[0][segun + 1], pixels.Color(255, 0, 0));  //nº horizontal
  pixels.setPixelColor(asignacion[1][segun + 1], pixels.Color(255, 0, 0));
  if (fasel <= 3) {
    for (int j = 0; j < prime; j++) {  //Areas azules
      for (int i = 0; i < segun; i++) {
        pixels.setPixelColor(asignacion[j + 2][i + 2], pixels.Color(0, 0, 255));
      }
    }
  }
}