#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Fonts/FreeSansBold12pt7b.h>
#include <SimpleDHT.h>
#define SCREEN_WIDTH 128  // OLED display width, in pixels
#define SCREEN_HEIGHT 64  // OLED display height, in pixels
// Declaration for an SSD1306 display connected to I2C (SDA, SCL pins)
// The pins for I2C are defined by the Wire-library.
// On an arduino UNO:       A4(SDA), A5(SCL)
// On an arduino MEGA 2560: 20(SDA), 21(SCL)
// On an arduino LEONARDO:   2(SDA),  3(SCL), ...
#define OLED_RESET -1        // Reset pin # (or -1 if sharing Arduino reset pin)
#define SCREEN_ADDRESS 0x3C  ///< See datasheet for Address; 0x3C for 128x64, 0x3D for 128x32
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);
#define pinDHT22 2
SimpleDHT22 dht22(pinDHT22);
float valor = 0;
float humedad = 0;
float tempMin = 22;  // valor inicial muy alto
float tempMax = 13;  // valor inicial muy bajo
int err = SimpleDHTErrSuccess;

void setup() {
  Serial.begin(9600);
  Serial.println("Saludos, termometro 2/1/2026");
  // Wait for display
  delay(500);
  if (!display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS)) {
    Serial.println(F("SSD1306 allocation failed"));
    for (;;)
      ;  // Don't proceed, loop forever
  }
  display.clearDisplay();
  display.setFont(&FreeSansBold12pt7b);
  display.setTextSize(1);               // Normal 1:5 pixel scale
  display.setTextColor(SSD1306_WHITE);  // Draw white text
  display.setCursor(35, 15);
  display.print("2026");
  display.setCursor(8, 50);
  display.print("GENIERO");
  display.display();
  display.setTextSize(2);  
  delay(1500);

}

void loop() {
  if ((err = dht22.read2(&valor, &humedad, NULL)) != SimpleDHTErrSuccess) {
    Serial.print("No se encuentra Termometro, err=");
    Serial.println(err);
    delay(2000);
    return;
  }
  // Actualizar temperatura mínima
  if (valor < tempMin) {
    tempMin = valor;
  }
  // Actualizar temperatura máxima
  if (valor > tempMax) {
    tempMax = valor;
  }
  display.clearDisplay();
  int barraY = 6;
  int barraAltura = 8;
  // Marco
  display.drawRect(0, barraY, 128, barraAltura, SSD1306_WHITE);
  // Ancho proporcional a la humedad
  int anchoBarra = (int)(humedad * 128.0 / 100.0);
  // Relleno
  display.fillRect(1, barraY + 1, anchoBarra - 2, barraAltura - 2, SSD1306_WHITE);
  //linea central
  if (humedad <= 50) {
    display.drawLine(62, barraY, 62, barraY + barraAltura - 1, SSD1306_WHITE);
  } else {
    display.drawLine(62, barraY, 62, barraY + barraAltura - 1, SSD1306_BLACK);
  }
  // Convertimos a texto con 1 decimal
  char buffer[10];
  dtostrf(valor, 0, 1, buffer);  // 1 decimal
  if (valor != tempMax && valor != tempMin) {
    printSpaced(buffer, 3, 59, 40);
  } else {
    printmax(buffer, 3, 59, 40);
  }
  display.display();
  // DHT22 sampling rate is 0.5HZ.
  delay(2000);
}

void printSpaced(String txt, int x, int y, int spacing) {
  // imprimimos el entero
  display.setTextColor(SSD1306_WHITE);  // texto invertido
  for (int i = 0; i < 2; i++) {
    display.setCursor(x + i * spacing, y);
    display.print(txt[i]);
  }
  //Aquí se imprimen el punto y los decimales
  display.setCursor(77, y);
  display.print(txt[2]);
  display.setCursor(97, y);
  display.print(txt[3]);
}

void printmax(String txt, int x, int y, int spacing) {
  // imprimimos el entero
  display.fillRect(0, 22, 128, 64, SSD1306_WHITE);
  display.setTextColor(SSD1306_BLACK);  // texto invertido
  for (int i = 0; i < 2; i++) {
    display.setCursor(x + i * spacing, y);
    display.print(txt[i]);
  }
  //Aquí se imprimen el punto y los decimales
  display.setCursor(77, y);
  display.print(txt[2]);
  display.setCursor(97, y);
  display.print(txt[3]);
}
